/** @file   UltimateBadAssAi.cpp
 * @brief   Implementation of UltimateBadAssAi class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/07/13 16:27:44 $
 * @author  Tomi Lamminsaari
 */

#include "UltimateBadAssAi.h"
#include "warglobals.h"
#include "utils.h"
#include "www_assert.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
UltimateBadAssAi::UltimateBadAssAi( GameObject* aObject ) :
  AIController( aObject ),
  iAlienState( EAlienStateAttack ),
  iStateCounter( 10 ),
  iSameStateCounter( 0 )
{
  AIController::m_visualRange = 500;
  AIController::m_attackRange = 300;
  this->setFlags( AIController::WAIT_TARGET );
}



/** Destructor.
 */
UltimateBadAssAi::~UltimateBadAssAi()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Updates this controller.
 */
void UltimateBadAssAi::updateAI( bool aSeeTarget, float aDistance )
{
  if ( iAlerted == false ) {
    if ( aSeeTarget == true ) {
      iAlerted = true;
    } else {
      // We haven't seen player yet, so we stay put
      this->reset();
      this->setCounter( 5 + rand() % 5 );
      return;
    }
  }
  this->setRandomMovement( 10 + rand() % 10 );

  switch ( iAlienState ) {
    case ( EAlienStateAttack ): {
      this->updateAttackState();
      break;
    }
    case ( EAlienStateMove ): {
      this->updateMoveState();
      break;
    }
  }
}

void UltimateBadAssAi::setAlerted(bool aAlerted)
{
  iAlerted = aAlerted;
  AIController::m_flags &= ~AIController::WAIT_TARGET;
}

void UltimateBadAssAi::updateAttackState()
{
  bool seeTarget = this->canSeeTarget();
  bool withinRange = this->withinAttackRange();
}

void UltimateBadAssAi::updateMoveState()
{

}

UltimateBadAssAi::AlienState UltimateBadAssAi::currentAiState() const
{
  return iAlienState;
}

};  // end of namespace
